libname rcs 'C:\stats\RMC06';
data rcs.rural_dsorted_S80;
set rcs.rural_dsorted_short;  
where density > 15.918918919 and density <=  24.8 ;
* 56,980> obs> 42,734;
* the fourth quintile of the edited sampled rural routes;
LC_H=32.617285;    *RURAL CARRIER LABOR COST PER EVALUATED HOUR IN 2006&2007*;
PGBFCTR=1.24296775;  *RURAL CARRIER PIGGYBACK FACTOR FOR SUPERVISION,
                      SPACE AND SPACE RELATED COSTS FROM ACR2007-1*;

LC_MIN=LC_H/60; *RURAL CARRIER LABOR COST PER EVALUATED MINUTE*;                

BOXESRLC_R = BOXESRT * LC_MIN;  
*DIRECT LABOR COST TO DELIVER TO STAND-ALONE BOXES PER ROUTE PER DAY;
* BOXESRT is the time to deliver to each stand-alone box (minutes/day);
BOXESROHLC_R =  BOXESRLC_R*(PGBFCTR-1); 
*RURAL CARRIER OVERHEAD COST  TO DELIVER TO STAND-ALONE BOXES PER ROUTE PER DAY*;
BOXESRDC_R = BOXESRLC_R + BOXESROHLC_R; 
*TOTAL DELIVERY COST TO STAND-ALONE BOXES PER ROUTE PER DAY*;


IF BOXESR> 0 THEN delcost_boxesR =  BOXESRDC_R/BOXESR;    
* average delivery cost to a stand-alone box per rural route in 2006&2007;

BOXESCLC_R = BOXESCT * LC_MIN;  
*DIRECT LABOR COST TO DELIVER TO A CENTRALIZED BOX PER ROUTE PER DAY;
* BOXESCT is the time to deliver to each CENTRALIZED box (minutes/day);
BOXESCOHLC_R =  BOXESCLC_R*(PGBFCTR-1); 
*RURAL CARRIER OVERHEAD COST  TO DELIVER TO CENTRALIZED BOXES PER ROUTE PER DAY*;
BOXESCDC_R = BOXESCLC_R + BOXESCOHLC_R; 
*TOTAL DELIVERY COST TO CENTRALIZED BOXES PER ROUTE PER DAY*;

IF BOXESC> 0 THEN delcost_boxesC =  BOXESCDC_R/BOXESC;    
* average delivery cost to a centralized box per rural route in 2006&2007;

efficiency_centralized= (delcost_boxesc/delcost_boxesr)*100;
* the cost efficiency factor of delivering to a centralized box vs.
a stand-alone box (in percentage);

TEVMNBOXES= BOXESRT + BOXESCT;
* TOTAL evaluated time to deliver to stand-alone and centralized boxes per route-day (min);
EVALMN_BOX= TEVMNBOXES/TBOXES;
* daily evaluated time per box (stand alone and centralized) per route (min);

run;
* DELETED THE last 3 LINES- SAME DENSITY WITH 80% QUINTILE LINE;
* 14245 obs;
